<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use App\Models\Trainer;
use App\Models\Notification;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'certificate_name',
        'email',
        'phone',
        'role'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'remember_token',
        'password'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function certificate()
    {
        return $this->hasOne(Certificate::class,'student_id');
    }
    public function notificationFrom()
    {
        return $this->hasMany(Notification::class, 'from_user_id');
    }

    public function notificationTo()
    {
        return $this->hasMany(Notification::class, 'to_user_id');
    }

    public function rooms()
    {
        return $this->hasMany(ClassRoom::class,'trainer_id');
    }

    public function CoordinatorRooms()
    {
        return $this->hasMany(ClassRoom::class,'coordinator_id');
    }

    public function subscribes()
    {
        return $this->hasMany(StudentSubscribe::class,'student_id');
    }
    public function trainer()
    {
        return $this->hasOne(Trainer::class,'trainer_id');
    }
#Scope
######################
#######################
    public function scopeTrain($query)
    {
        return $query->where('role', 1);
    }

    public function scopeStudent($query)
    {
        return $query->where('role', 2);
    }

    public function scopeCoordinate($query)
    {
        return $query->where('role', 3);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }
    public function scopeResetPass($query)
    {
        return $query->where('is_reset', 1);
    }

}
